//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------


#include <cpctelera.h>
#include "video.h"
#include "../defines.h"
#include "../sprites/sprites.h"
#include "../entities/types.h"
#include "../text/text.h"
#include "../sound/music.h"
#include "../entities/entities.h"

#ifndef _DRAW_H_
#define _DRAW_H_

extern u8 language;
extern u8 gameOver;
extern u8 pause;
extern u16 score;
extern u8 lives;
extern u8 level;

void drawTarget(Entity *target, u8 draw);
void drawHero(Entity *hero, Entity *target, Bullet *enemyBullets, u8 draw);
void drawEnemies(Entity *enemies, u8 draw, Entity *hero, Bullet *bullets);
u8 moveEnemies(Entity *emenies, Entity *target, Entity *hero, cpct_keyID fire, u8 protection);
//void drawSelector(u8 color, u8 xPos, u8 yPos);
void clearGameScreen();
void drawBullets(Bullet *bullets, u8 draw);
void moveBullets(Entity *bike, Bullet *bullets);
void drawLives();
void drawTileBox2x4(i8 txPos, u8 tyPos, u8 tWidth, u8 tHeight, u8* buffer, u8 map);
void updateScoreboard();
void clearBullets(Bullet *enemyBullets);

#endif
